#lang racket

(require db)

;;;;;;;;;;;;;;;;;;

(define CHINOOK "/path/to/Chinook_Sqlite_AutoIncrementPKs.sqlite")
(define ARTIST "U2")

(define (output-row v)
  (printf "<~a> ~a~n" (vector-ref v 0) (vector-ref v 1)))

;;;;;;;;;;;;;;;;;;

(define DB-CONN
  (sqlite3-connect #:database CHINOOK))

(define RESULTS
  (if (string=? ARTIST "n/a")
      (query-rows DB-CONN
                  "SELECT art.Name AS art_name, alb.Title AS alb_title FROM album alb INNER JOIN artist art ON alb.ArtistId=art.ArtistId ORDER BY art_name ASC, alb_title ASC")
      (query-rows DB-CONN
                  "SELECT art.Name AS art_name, alb.Title AS alb_title FROM artist art INNER JOIN album alb ON art.ArtistId=alb.ArtistId WHERE art.Name LIKE ? ORDER BY art_name ASC, alb_title ASC"
                  ARTIST)))

(for ([row RESULTS])
          (output-row row))

(disconnect DB-CONN)
