/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;

public class ColumnNameMap {
    private Map<String, Integer> labelMap;
    private final ColumnInformation[] columnInfo;

    public ColumnNameMap(ColumnInformation[] columnInformations) {
        this.columnInfo = columnInformations;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (this.labelMap == null) {
            this.labelMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnAlias = ci.getName().toLowerCase();
                this.labelMap.putIfAbsent(columnAlias, counter);
                String tableName = ci.getTable();
                if (tableName != null && !tableName.isEmpty()) {
                    this.labelMap.putIfAbsent(tableName.toLowerCase() + "." + columnAlias, counter);
                }
                ++counter;
            }
        }
        if ((res = this.labelMap.get(name.toLowerCase())) == null) {
            throw new SQLException("No such column :" + name);
        }
        return res;
    }
}

